import matplotlib.pyplot as plt
import numpy as np
import numpy.random as rd

Vs = [[],[],[],[],[],[],[],[],[],[0,0]] # à compléter LORS DU TP : les valeurs des tensions [Umin,Umax] pour les angles alpha = 0°,10°,...90°

# joli tracé des courbes Vs = f(alpha) théorique en bleu et expérimentale en rouge
X1 = [i*10 for i in range(10)] # angles en degrés
Y_exp = [0.5*(Vs[i][0]+Vs[i][1]) for i in range(10)]
X2 = [i for i in range(91)] # angles en degrés variant de 1 en 1 pour le tracé théorique
Y_th = [0.5*(Vs[0][0]+Vs[0][1])*(np.cos(i/180*np.pi))**2 for i in range(91)]
plt.figure('loi de Malus')
plt.plot(X1,Y_exp,color ='r',marker = 'o',label='valeur expérimentale')
plt.plot(X2,Y_th,color='b',label='valeur théorique')
plt.title(r"Tension en fonction de l'angle $\alpha$")
plt.legend()
plt.xlabel(r'angle $\alpha$ entre A et P en degrés')
plt.ylabel('Tension en V')
plt.grid(True)
plt.show()
        

# Méthode de Monte-Carlo pour obtenir les incertitudes sur Uth(alpha)

N = 1000000  # nombre de simulations

U0_simul = rd.uniform() # à compléter : valeurs simulées de U(alpha = 0)

def U(U0,alpha): # valeur théorique de la tension de sortie
    return U0*(np.cos(alpha))**2 # les angles doivent être en radian !
    
for i in range(0,9): # calcul et affichage des Z-scores pour alpha = 0°,...,80°
    alpha_simul = rd.uniform((i*10-2)/180*np.pi,(i*10+2)/180*np.pi,N) # on prend une tolérance +/- 2° sur les angles
    Xth = U(U0_simul,alpha_simul)
    Uth = np.mean(Xth)
    u_Uth = np.std(Xth,ddof = 1)
    # commenter les 4 lignes précédentes
    Uexp = # à compléter : valeur expérimentale de Vs pour l'angle alpha_i = i*10/180*np.pi
    u_Uexp = # à compléter : incertitude-type expérimentale sur Vs pour l'angle alpha_i
    Z = # à compléter : valeurs du Z-score
    print (Z)



